%  pend2.m
% Matlab file for Part 2 of The Pendulum module
global g m b L

disp('*********************************************')
disp('Part 2:  The Phase Plane ')
disp('*********************************************')
disp('  ')    

    format short

    disp('Step 1: ')
    disp('Here are the values of the parameters used')
    disp('in this part.  Note that in this part we')
    disp('assume no damping or friction, i.e., b = 0 ')
    disp(' ')
    disp('Copy the following commands as a group, paste ')
    disp('them at the MATLAB prompt, and execute them. ')
    disp(' ')
    disp(' g = 9.807;  % acceleration of gravity (m/s^2)')
    disp(' m = 1;      % mass of bob (kg)')
    disp(' b = 0;      % damping coefficient (kg/s)')
    disp(' L = 1;      % length of rod (m)')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 1 (cont.) ')
    disp(' ')
    disp('In this module, we will use MATLAB''s')
    disp('build-in numerical DE solver:')
    disp(' [t,z]=ode45(function_name,[t0,tf],z0)')
    disp('    where z0=[theta0,thetap0]'', a column vector, ')
    disp('    gives the initial conditions. ')
    disp(' ')
    disp('The following commands will solve the pendulum')
    disp('DE and plot solution for two sets of initial ')
    disp('conditions. The plots will be overlayed.')
    disp(' ')
    disp('Enter:')
    disp(' ')
    disp('  figure(1); clf  % Clears figure')
    disp('  theta0 = 0.5; thetap0=0; z0=[theta0;thetap0];')
    disp('  [t,z]=ode45(''de_rhs'',[0,10],z0); ')
    disp('  theta1=z(:,1); thetap1=z(:,2);  ')
    disp('  plot(t,theta1,''k''); hold on ')
    disp('  theta0 = 2; thetap0=0; z0=[theta0;thetap0];')
    disp('  [t,z]=ode45(''de_rhs'',[0,10],z0); ')
    disp('  theta2=z(:,1);  thetap2=z(:,2);  ')
    disp('  plot(t,theta2,''r''); grid on ')
    disp(' ')
    disp('----------------------------------------------')
    disp('Explain what you see in the plot.')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 2:')
    disp('The following MATLAB function:')
    disp('    dirfield(xmin,xmax,ymin,ymax) ')
    disp('for plotting direction fields is contained')
    disp('in a m-file provided with this module.')
    disp(' ')
    disp('Let''s plot in figure 2 the phase plane for the')
    disp('pendulum DE and superimpose the two solutions')    
    disp('we found in step 1. ')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  figure(2); clf ')
    disp('  dirfield(-2,2, -5.5,5.5); hold on ')
    disp('  plot(theta1,thetap1,''k'')  ')
    disp('  plot(theta2,thetap2,''r'')  ')
    disp('  axis equal;axis([-2,2, -5.5,5.5]) ')
    disp(' ')
    disp('----------------------------------------------')
    disp('Explain what you see in the plot.  Compare')
    disp('the plot of the solutions in figure 1. ')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 3:')    
    disp('Add modest damping to the model.')
    disp(' ')
    disp('Enter')
    disp(' ')
    disp('  b = 0.2 ')
    disp(' ') 
    disp('Now repeat steps 1 and 2 using the same commands.')
    disp(' ')
    disp('----------------------------------------------')
    disp('Explain what you see in the new plots. Compare')
    disp('figure 1 to figure 2. ')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 4:')    
    disp('Experiment with various values of the damping')
    disp('coefficient b.  Redo steps 1 and 2 for various')
    disp('values of b.')
    disp(' ')
    disp('----------------------------------------------')
    disp('Describe how the solutions change as b varies.')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp(' ') 
    disp('----------------------------------------------')
    disp('When your answers are done, to go on to')
    disp('part 3 of this module, type: pend3')
    disp(' ')