%  eigval1.m
% Matlab file for Part 1 of the Eigenvalues and 
% Eigenvectors module

disp('*********************************************')
disp('Part 1:  Calculation of Eigenvalues and ')
disp('         Eigenvectors ')
disp('*********************************************')
disp('  ')    

    format short
    
    disp('Enter the matrices A, B, C, I by copying')
    disp('the following commands as a group, pasting ')
    disp('them at a MATLAB prompt, and executing them.')
    disp(' ')
    disp('     A = [2,1,1; 2,3,4; -1,-1,-2]  ')
    disp('     B = [2,-1,1; 0,3,-1; 2,1,3]  ')
    disp('     C = [2,1,1; 2,3,2; 3,3,4] ')
    disp('     I = eye(3,3) ')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 1: ')
    disp('We will use MATLAB''s symbolic capabilities')
    disp('to find and factor the characteristic polynomial')
    disp('for matrix A. ')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  syms lam ')
    disp('  cpoly=det( A - lam*I ) ')
    disp('  factor(cpoly) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Write down the eigenvalues of matrix A. ')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 2 and 3')
    disp('Entering the following command will yield')
    disp('the row-reduced echelon form of A - 1*I . ')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  lam = 1 ')
    disp('  rref( A - lam*I) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Explain why this enables you to write down an ')
    disp('eigenvector v corresponding to the eigenvalue lam=1.')
    disp('Check that your eigenvector v is correct by ')
    disp('computing Av and comparing to 1*v.')
    disp(' ')
    disp('Describe all eigenvectors of A that correspond')
    disp('to the eigenvalue 1. ')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;   
    disp(' ')
    
    disp('----------------------------------------------')
    disp('Step 4: ')
    disp('Find the eigenvectors corresponding to the other')
    disp('eigenvalues of A.  Repeat the process of steps')
    disp('2 and 3. ')
    disp(' ')
    disp('------------------------------------------------')   
    disp('Describe your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;   
    disp(' ')
    
    disp('----------------------------------------------')
    disp('Step 5: ')
    disp('Now find the eigenvalues and eigenvectors for')
    disp('matrix B.  Repeat this process for matrix C.')
    disp(' ')
    disp('------------------------------------------------')
    disp('How do the calculations for A, B, and C differ? ')   
    disp('Describe your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;   
    disp(' ')
 
    disp('----------------------------------------------')
    disp('Step 6: ')
    disp('The built-in function ''''eig'''' in MATLAB ')
    disp('calculates the eigvalues, or both the eigenvalues ')
    disp('and eigenvector of a matrix, depending on how')
    disp('it is used.  The eigenvectors are scaled so they')
    disp('each have length one.  See below.')
    disp(' ')
    disp('Enter:')
    disp(' ')
    disp('  eig(A) ')
    disp('  [V, D] = eig(A) ')
    disp(' ')
    disp('----------------------------------------------')
    disp('Do the checking calulations requested in step 6.')  
    disp('Explain your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp(' ')
    disp('----------------------------------------------')
    disp('To go on to part 2 of this module, ')
    disp('type: eigval2')
    disp(' ')