%  eigval4.m
% Matlab file for Part 4 of the Eigenvalues and 
% Eigenvectors module

disp('*********************************************')
disp('Part 4:  The Trace Operation')
disp('*********************************************')
disp('  ')    

    format short
    
    A = [2,1,1; 2,3,4; -1,-1,-2];
    B = [2,-1,1; 0,3,-1; 2,1,3];
    C = [2,1,1; 2,3,2; 3,3,4];
    I = eye(3,3);

    disp('Step 1: ')
    disp('The following commands show the matrix A')
    disp('followed by the trace of A.  Also the')
    disp('diagonal matrix F is entered. ')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  A ')
    disp('  trace(A) ')
    disp('  F = diag( [2, 4, 3] ) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Execute similar commands for matrices B, C, ')
    disp('and F.  Compare each matrix to its trace.')
    disp(' ')
    disp('Formulate a rule on how the trace may be calculated')
    disp('in terms of the entries of the matrix.')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 2')
    disp('Entering the following commands will generate')
    disp('a random 3 by 3 matrix G and compute its trace.')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  G = floor( 50*(2*rand(3)-1) ) ')
    disp('  trace(G) ')
    disp(' ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Check the rule you have formulated by seeing')
    disp('if it holds for various random matrices.')
    disp(' ')
    disp('Describe your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;   
    disp(' ')
    
    disp('Step 3: ')
    disp('The following commands show the eigenvalues of')
    disp('the matrix A followed by the trace of A.')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  e = eig(A) ')
    disp('  trace(A) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Execute similar commands for matrices B, C, ')
    disp('and F.  Compare each matrix to its trace.')
    disp(' ')
    disp('Formulate a rule relating the eigenvalues of a')
    disp('matrix to its trace.')
    disp('Use MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 4')
    disp('Entering the following commands will generate')
    disp('a random 3 by 3 symmetric matrix R and compute')
    disp('eigenvalues and its trace.')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  R = floor( 50*(2*rand(3)-1) ); R = R + R''  ')
    disp('  e = eig(R) ')
    disp('  trace(R) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Check the rule you have formulated in step 3 by ')
    disp('seeing if it holds for various random matrices.')
    disp('You can change the size of the matrix by replacing')
    disp('the ''''3'''' in the ''''rand(3)'''' by the size ')
    disp('of the square matrix you want. ')
    disp(' ')
    disp('Describe your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    disp('----------------------------------------------')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 5')
    disp('Entering the following commands will generate')
    disp('a random 3 by 3 matrix G (not necessary symmetric')
    disp(' and compute its eigenvalues and its trace.')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  G = floor( 50*(2*rand(3)-1) ) ')
    disp('  e = eig(G) ')
    disp('  trace(G) ')
    disp(' ')
    disp('------------------------------------------------')
    disp('Check the rule you have formulated in step 3 by ')
    disp('seeing if it holds for various random matrices.')
    disp('You can change the size of the matrix by replacing')
    disp('the ''''3'''' in the ''''rand(3)'''' by the size ')
    disp('of the square matrix you want. ')
    disp(' ')
    disp('Describe your results by using MATLAB comments in')
    disp('your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 6: ')
    disp('Use MATLAB comments in your file to explain why')
    disp('your rule must be true for diagonal matrices.') 
    disp(' ')
    disp(' ')
    disp('----------------------------------------------')
    disp('To go on to part 5 of this module, ')
    disp('type: eigval5')
    disp(' ')