%  ppmodel2.m
% Matlab file for Part 2 of the Predator-Prey Models module
% in the Differential Equations section.
global a b c p

disp('********************************************')
disp('Part 2:  The Lotka-Volterra Model')
disp('********************************************')
disp('  ')    

    format short
    disp('Steps 1 thru 3: ')
    disp('Enter your answers to the questions as')
    disp('MATLAB comments for your')
    disp('diary file.') 
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 4:')    
    disp('Here are parameters needed by the model:')
    a=1
    b=0.03
    c=0.4
    p=0.01
    disp(' ')
    disp('To continue, hit any key!')
    disp(' ')
    pause

    disp(' ')
    disp('----------------------------------------------')
    disp('Step 4 (cont.):')
    disp('In order to draw the direction field,')
    disp('for a system of differential equations,')
    disp('you must first define a MATLAB function')
    disp('giving the two right hand sides of the')
    disp('system in an m-file called de_rhs.m.')
    disp(' ')
    disp('------------------------------------------')  
    disp('An example de_rhs.m file is included')
    disp('with the files provided with this')
    disp('module.  The original is set up for')
    disp('the Lotka-Volterra system:')
    disp('      dx/dt = a*x-b*x*y')
    disp('      dy/dt = -c*y+p*x*y')
    disp('You can edit it for other systems.')
    disp(' ')
    disp('To list the de_rhs file while in MATLAB, ')
    disp('enter ''''type de_rhs'''' ')
    disp(' ')
    disp('To continue, hit any key!')
    disp(' ')
    pause

    disp(' ')
    disp('------------------------------------------')
    disp('Step 4 (cont.):')
    disp('The following MATLAB function:')
    disp('    dirfield(xmin,xmax,ymin,ymax) ')
    disp('for plotting direction fields is contained')
    disp('in a m-file provided with this module.')
    disp(' ')
    disp('Copy the following commands and paste them as')
    disp('a group at a MATLAB prompt, then execute them.')
    disp(' ')
    disp('     dirfield(0,140,0,80) ')
    disp('     hold on')
    disp(' ')
    disp('Note: the ''hold on'' command saves the plot')
    disp('so we can add other curves to it.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 5:')
    disp('We add solution curves by solving the')
    disp('system of D.E.s under various specified')
    disp('initial conditions and then plotting them')
    disp('on top of the direction field.')
    disp(' ')
    disp('For efficiency, we will use MATLAB''s')
    disp('build-in numerical DE solver:')
    disp('  [t,z]=ode45(function_name,[t0,tf],z0)')
    disp('        where z0=[x0,y0]'', a column vector, ')
    disp('           gives the initial conditions. ')
    disp(' ')
    disp('Copy the following commands and paste them as')
    disp('a group at a MATLAB prompt, then execute them.')
    disp(' ')
    disp('  z0=[15,15]''; ')
    disp('  [t,z]=ode45(''de_rhs'',[0,12],z0); ')
    disp('   x=z(:,1);  ')
    disp('   y=z(:,2);  ')
    disp('  plot(x,y,''r'') ')
    disp(' ')
    disp('A red solution curve satisfying initial')
    disp('condition x(0)=15 , y(0)=15 should appear')
    disp('on top of the direction field.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Step 5 (cont.) ')
    disp('Using the same procedure, add 3 more')
    disp('solution curves to the plot corresponding')
    disp('to initial conditions (x0,y0)=(20,20),')
    disp('(x0,y0)=(25,25), and (x0,y0)=(30,30)')
    disp(' ')
    disp('Just change the ''''z0=[ , ]'''' line and reexecute')
    disp('the above commands.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')
  
    disp('----------------------------------------------')
    disp('Step 6:')  
    disp('Enter the following formulas to calculate the')
    disp('coordinates of the equilibrium point.')
    disp(' ')
    disp('  xs = c/p ')
    disp('  ys = a/b ')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('----------------------------------------------')
    disp('Steps 7 thru 9: ')    
    disp('Enter your answers to the remaining')
    disp('questions in Part 2 as MATLAB comments')
    disp('in your diary file.')
    disp(' ')
    disp(' ') 
    disp('When your answers are done, to go on to')
    disp('part 3 of this module, type: ppmodel3')
    disp(' ')
