%  ppmodel5.m
% Matlab file for Part 5 of the Predator-Prey Models module
% of the Differential Equations section
global a b c p

disp('********************************************')
disp('Part 5:  The Effect of Hunting Predators')
disp('             (Optional) ')
disp('********************************************')
disp('  ')    

    format short

    disp('Step 1:')
    disp('Use a text editor to modify the m-file')
    disp('de_rhs (it is provided with this module).')
    disp('Make the simple modification to subtract')
    disp('5 in the rhs of the second equation. ')
    disp(' ')
    disp('After editing, you can list the modified ')
    disp('m-file in MATLAB by entering ''''type de_rhs''''. ')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('------------------------------------------------')
    disp('Step 1 (cont.):')
    disp('The following commands from Part 4 will ')
    disp('plot the direction field of the new system ')
    disp('and some trajectories on top of it.')
    disp(' ')
    disp('You may want to change the window size for')
    disp('the plot, some of the initial conditions, and ')
    disp('the time span after experimenting with them.')
    disp(' ')
    disp(' a=1; b=0.03; c=0.4; p=0.01; ')
    disp(' figure(1); clf; dirfield(0,200,0,100); hold on ')
    disp(' [t,z]=ode45(''de_rhs'',[0,15], [50,50]''); ')
    disp(' plot(z(:,1), z(:,2), ''r'') ')
    disp(' [t,z]=ode45(''de_rhs'',[0,17], [100,30]''); ')
    disp(' plot(z(:,1), z(:,2), ''k'') ')
    disp(' [t,z]=ode45(''de_rhs'',[0,7], [30,80]''); ')
    disp(' plot(z(:,1), z(:,2), ''g'') ')
    disp(' axis([0,200, 0,100])')
    disp(' ')
    disp('-------------------------------------------------')
    disp('Describe what happens in this new model.  Address')
    disp('all the questions in step 1.  Use MATLAB comments')
    disp('in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('------------------------------------------------')
    disp('Step 2: ')
    disp('Make a different change in the predator-prey')
    disp('differential equation to reflect a different')
    disp('biological consideration.')
    disp(' ')
    disp('Use your text editor to again modify the ')
    disp('de_rhs.m file to reflect your new model.')
    disp(' ')
    disp('Use the plotting commands above, with the ')
    disp('appropriate modifications, to plot trajectories ')
    disp('of your new system.')
    disp(' ')
    disp('-------------------------------------------------')
    disp('Describe what happens in this new model.  Address')
    disp('all the questions in step 2.  Use MATLAB comments')
    disp('in your diary file.')
    
    disp(' ')
    disp(' ')
    disp('----------------------------------------------------')
    disp('To go on to part 6 of this module,')
    disp('type: ppmodel6')
    disp(' ')
