%  ppmodel3.m
% Matlab file for Part 3 of the Predator-Prey Models module
% of the Differential Equations section
global a b c p

disp('********************************************')
disp('Part 3:  Graphical Representations')
disp('********************************************')
disp('  ')    

    format short

    a=1;b=0.03;c=0.4;p=0.01;
    disp('Step 1 and 2: ')
    disp('We want to plot the prey population as a')
    disp('function of time and likewise the predator')
    disp('population as a function of time.')
    disp('Let''s choose the first scenario in')
    disp('which (x0,y0)=(15,15) and look at the')
    disp('populations over two periods.')
    disp(' ')
    disp('First we solve the system over two periods.')
    disp('For efficiency, we will use MATLAB''s')
    disp('build-in numerical DE solver:')
    disp('  [t,z]=ode45(function_name,[t0,tf],z0)')
    disp('        where z0=[x0,y0]'', a column vector ')
    disp('              of initial conditions.')
    disp(' ')
    disp('--------------------------------------------')
    disp('Copy the following commands and paste them as')
    disp('a group at a MATLAB prompt, then execute them.')
    disp(' ')
    disp('  z0=[15,15]''; ')
    disp('  [t,z]=ode45(''de_rhs'',[0,24], z0); ')
    disp('   x=z(:,1);  ')
    disp('   y=z(:,2);  ')
    disp(' ')
    disp('To check, type the variable name: t, which')
    disp('should give times from 0 to 24 used by ode45.')
    disp('Then type the variable name: x to see the')
    disp('corresponding x values.')
    disp('Likewise, you can type y to see those values.') 
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')

    keyboard;
    disp(' ')

    disp('------------------------------------------------')
    disp('Step 1 (cont.): ')
    disp('Now, let''s look at a plot of the x(t) solution')
    disp('for the prey (in red).  On the same plot, we ')
    disp('will show the y(t) solution for the predator') 
    disp('(in green).')
    disp(' ')
    disp('Copy the following commands and')
    disp('paste them as a group at a MATLAB prompt')
    disp('to execute them.')
    disp(' ')
    disp('     clf ')
    disp('     plot(t,x,''r'') ')
    disp('     hold on ')
    disp('     plot(t,y,''g'') ')
    disp('     legend(''prey'',''predator'') ')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    
    keyboard;
    disp(' ')

    disp('----------------------------------------------------')
    disp('Steps 3 and 4: ')
    disp('Enter your answers to the questions in steps 3 and 4')
    disp('as MATLAB comments in your diary file.')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    
    keyboard;
    disp(' ')
   
    disp('----------------------------------------------------')
    disp('MATLAB has a special graphing function called ')
    disp('''''comet'''' that can show us the time evolution ')
    disp('of the prey-predator system.')
    disp(' ')
    disp('Enter:')
    disp(' ')
    disp('  clf ')
    disp('  dirfield(0,140,0,80); hold on ')
    disp('  comet(x,y) ')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    
    keyboard;
    disp(' ')

    disp('----------------------------------------------------')
    disp('Step 5: ') 
    disp(' ')
    disp('Now we will show the points (x,y,t) in 3-space')
    disp('to observe the time evolution of the trajectory.')
    disp(' ')
    disp('Enter: ')
    disp(' ')
    disp('  clf ')
    disp('  plot3(x,y,t,''r'') ')
    disp('  grid on')
    disp(' ')
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    
    keyboard;
    disp(' ')

    disp('----------------------------------------------------')
    disp('Step 6 thru 8:')
    disp('To change the viewpoint in MATLAB, the version you')
    disp('are running may have a 3D rotatation capability')
    disp(' ')
    disp('If the upper border of your figure window has a')
    disp('little circle with a conterclockwise arrow on it,')
    disp('clicking that icon will allow you to click your')
    disp('plot and drag it to view from any angle.')
    disp(' ')
    disp('If your version of MATLAB does not have this')
    disp('capability, you need to use the ''''view'''' command to')
    disp('change the viewpoint.  You never have to replot the')
    disp('the points. ')
    disp(' ')
    disp('As an example, enter each of these commands separately:')
    disp(' ')
    disp('  view(45,60) ')
    disp('  view(0,0) % View along x-axis ')
    disp('  view(90,0) % View along y-axis ')
    disp('  view(0,90) % Top view')
    disp(' ')
    disp('The first argument to ''''view'''' is the azimuth angle,')
    disp('measured in the xy plane from x toward y.  The second')
    disp('angle is the elevation angle as measured up from the')
    disp('xy plane.')
    disp(' ') 
    disp('To continue afterwards, type the word return')
    disp('and hit enter!')
    disp(' ')
    
    keyboard;
    disp(' ')

    disp('----------------------------------------------------')
    disp('Steps 6 thru 8 (cont.):')
    disp('Answer the questions in these steps as MATLAB comments')
    disp('in your diary file.')
    disp(' ')
    disp(' ')
    disp('----------------------------------------------------')
    disp('When your answers are done, to go on to')
    disp('part 4 of this module, type: ppmodel4')
    disp(' ')
